#ifndef BUTTONS_H_
#define BUTTONS_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_conf.h"

/* Exported types ------------------------------------------------------------*/
typedef enum
{
    BUTTONS_Blue       = GPIO_Pin_0,
    BUTTONS_LeftRed    = GPIO_Pin_7,
    BUTTONS_LeftBlack  = GPIO_Pin_6,
    BUTTONS_RightBlack = GPIO_Pin_5,
    BUTTONS_RightRed   = GPIO_Pin_11
}
Buttons_TypeDef;

/* Exported function prototypes ----------------------------------------------*/

// Buttons_Init()
// --------------
// Initialize the button module.
void Buttons_Init();

// Buttons_IsPressed()
// -------------------
// Determine if a given button is pressed.
#define Buttons_IsPressed(button) (GPIO_ReadInputDataBit(GPIOA, button) != 0)

#endif // BUTTONS_H_
